# -*- coding: UTF-8 -*-
import os, sys, traceback, json
from pyopus.misc.debug import DbgSetup, DbgMsgOut
DbgSetup(True, 1)

useMPI=False

projData={'analyses': {'AC': {'command': 'an_ac(1, 10e6, "dec", 100)',
                     'head': 'opus',
                     'modules': ['filter'],
                     'options': {},
                     'params': {},
                     'saves': []}},
 'analysisNames': ['AC'],
 'designPar': {},
 'designParNames': [],
 'headNames': ['opus'],
 'heads': {'opus': {'moddefs': {'filter': {'file': 'filter.cir'}},
                    'options': {},
                    'params': {},
                    'settings': {},
                    'simulator': 'SpiceOpus'}},
 'measureLower': {},
 'measureNames': [],
 'measureNorm': {},
 'measureUpper': {},
 'measures': {},
 'mirrormap': {'filter.cir': '.'},
 'opPar': {},
 'opParNames': [],
 'statPar': {},
 'statParNames': [],
 'variableNames': [],
 'variables': {}}

taskData={'cornerNames': ['nominal'],
 'corners': {('nominal', ('opus',)): {'modules': [], 'params': {}}},
 'fixedParameterNames': [],
 'name': 'analysis',
 'optParameterNames': [],
 'output': {'aggregatordebug': 0,
            'evaluatordebug': 0,
            'keepfiles': False,
            'optimizerdebug': 0,
            'saveallresults': False,
            'savewaveforms': 'verification',
            'simulatordebug': 0,
            'taskdebug': 1},
 'parameterNames': [],
 'parameters': {},
 'requirementNames': [],
 'requirements': {'exclude': [],
                  'lower': {},
                  'norm': {},
                  'tradeoff': {},
                  'upper': {}},
 'settings': {'aggregatorsettings': {},
              'evaluatorsettings': {},
              'failurepenalty': 1000000.0,
              'forwardsolution': True,
              'incrementalcorners': True,
              'initialstep': 0.25,
              'maxiter': None,
              'method': 'noneFull',
              'optimizersettings': {},
              'stopsatisfied': True,
              'stoptol': 1e-05,
              'tradeoffmultiplier': 0},
 'type': 'cbd'}

if __name__=='__main__':
  import numpy as np
  np.random.seed(0)

  if useMPI:
    from pyopus.parallel.mpi import MPI
    from pyopus.parallel.cooperative import cOS

    cOS.setDebug(mpiData['cosdebug'])
    if mpiData['mirror']:
      vm=MPI(mirrorMap=projData['mirrormap'], persistentStorage=mpiData['persistent'], debug=mpiData['vmdebug'])
    else:
      vm=MPI(debug=mpiData['vmdebug'])
    cOS.setVM(vm)

    hosts=MPI.vmStatus['hosts']
    slots=MPI.vmStatus['slots']
    DbgMsgOut('VM', 'Process list (total %d):' % (len(slots)))
    for host in hosts.keys():
      DbgMsgOut('VM', '  Host %s with %d process(es)' % (host, len(hosts[host]['slots'])))
      for slot in hosts[host]['slots']:
        DbgMsgOut('VM', '    slot %d: pid=0x%x (%d)' % (slot, slots[slot]['pid'], slots[slot]['pid']))

  from pyopus.design.sqlite import SQLiteDatabase
  sqld=SQLiteDatabase(os.path.join('..', taskData['name']+'.sqlite'))

  from pyopus.gui.tasks import taskRunner

  try:
    runner=taskRunner[taskData['type']]
    runner(projData, taskData, sqld)
  except Exception as e:
    DbgMsgOut('TASK', 'Task terminated due to exception.')
    DbgMsgOut('TASK', traceback.format_exc())
    sys.exit(1)

  if useMPI:
    cOS.finalize()
